<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use DateTime;

class EmployeeSchedules extends Model
{
    private $settings;

    public function __construct()
    {
        parent::__construct();
        $this->settings = CompanySetting::first();
    }

    protected $dates = ['start_time', 'end_time'];

    public function employee()
    {
        return $this->belongsTo(User::class);
    }

    public function getStartTimeAttribute($value)
    {
        return Carbon::createFromFormat('H:i:s', $value)->setTimezone($this->settings->timezone)->translatedFormat($this->settings->time_format);

        // if($this->validateDate($value)){
        //     return Carbon::createFromFormat('H:i:s', $value)->setTimezone(CompanySetting::first()->timezone);
        // }

        // return '';
    }

    public function getEndTimeAttribute($value)
    {
        return Carbon::createFromFormat('H:i:s', $value)->setTimezone($this->settings->timezone)->translatedFormat($this->settings->time_format);

        // if($this->validateDate($value)){
        //     return Carbon::createFromFormat('H:i:s', $value)->setTimezone(CompanySetting::first()->timezone);
        // }

        // return '';
    }

    public function getLocationStartTimeAttribute()
    {
        return Carbon::createFromFormat('H:i:s', $this->attributes['start_time'])->setTimezone($this->location->timezone->zone_name)->translatedFormat($this->settings->time_format);

        /* @phpstan-ignore-next-line */
        // return Carbon::createFromFormat('H:i:s', $this->attributes['start_time'])->setTimezone($this->location->timezone->zone_name)
    }

    public function getLocationEndTimeAttribute()
    {
        return Carbon::createFromFormat('H:i:s', $this->attributes['end_time'])->setTimezone($this->location->timezone->zone_name)->translatedFormat($this->settings->time_format);

        /* @phpstan-ignore-next-line */
        return Carbon::createFromFormat('H:i:s', $this->attributes['end_time'])->setTimezone($this->location->timezone->zone_name);
    }

    public function getUtcStartTimeAttribute()
    {
        return Carbon::createFromFormat('H:i:s', $this->attributes['start_time']);
    }

    public function getUtcEndTimeAttribute()
    {
        return Carbon::createFromFormat('H:i:s', $this->attributes['end_time']);
    }

    public function setStartTimeAttribute($value)
    {
        $BookingStartTime = Carbon::parse($value)->shiftTimezone($this->settings->timezone);
        $this->attributes['start_time'] = $BookingStartTime->setTimezone('UTC');
    }

    public function setEndTimeAttribute($value)
    {
        $BookingEndTime = Carbon::parse($value)->shiftTimezone($this->settings->timezone);
        $this->attributes['end_time'] = $BookingEndTime->setTimezone('UTC');
    }
    
    /* Mutator */

    public function validateDate($format = 'H:i:s')
    {
        $d = DateTime::createFromFormat('H:i:s', $format);
        return $d && $d->format($format);
    }

    public function location()
    {
        return $this->belongsTo(Location::class, 'location_id', 'id');
    }

}
