<?php

namespace App\Http\Controllers;

use App\Booking;
use App\ZoomMeeting;
use App\Traits\ZoomSettings;
use App\ZoomSetting;
use Illuminate\Support\Facades\Log;

class ZoomWebhookController extends Controller
{
    Use ZoomSettings;

    public function index()
    {
        $this->setZoomConfigs();
        $response = request()->all();

        info($response);

        Log::debug('response = ', request()->all());
        $event = $response['event'];

        switch ($event)
        {
        case 'meeting.started'  :
            $this->meetingStarted($response);
            break;

        case 'meeting.ended':
            $this->meetingEnded($response);
            break;
        case 'endpoint.url_validation':
            return $this->validateEndpointUrl($response);

        default:
            //
            break;
        }

        return response('Webhook Handled', 200);
    }

    protected function validateEndpointUrl($response)
    {
        $secret = ZoomSetting::first();

        $token = hash_hmac('sha256', $response['payload']['plainToken'], $secret->secret_token);

        $plain_token = $response['payload']['plainToken'];

        return response(['plainToken' => $plain_token, 'encryptedToken' => $token]);

    }

    public function meetingStarted($response)
    {
        $meetingId = $response['payload']['object']['id'];
        $meeting = ZoomMeeting::where('meeting_id', $meetingId)->first();
        $booking = Booking::findOrFail($meeting->booking_id);

        if ($meeting)
        {
            $meeting->status = 'live';
            $meeting->save();

            $booking->status = 'in progress';
            $booking->update();
        }
    }

    public function meetingEnded($response)
    {
        $meetingId = $response['payload']['object']['id'];
        $meeting = ZoomMeeting::where('meeting_id', $meetingId)->first();
        $booking = Booking::findOrFail($meeting->booking_id);

        if ($meeting)
        {
            $meeting->status = 'finished';
            $meeting->save();

            $booking->status = 'completed';
            $booking->update();
        }
    }

}
