<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Leave extends Model
{

    public function employee()
    {
        return $this->belongsTo(User::class);
    }

    public function getStartTimeAttribute($value)
    {
        return Carbon::createFromFormat('H:i:s', $value)->setTimezone(CompanySetting::first()->timezone)->translatedFormat(CompanySetting::first()->time_format);
    }

    public function getEndTimeAttribute($value)
    {
        return Carbon::createFromFormat('H:i:s', $value)->setTimezone(CompanySetting::first()->timezone)->translatedFormat(CompanySetting::first()->time_format);
    }

    public function getStartDateAttribute($value)
    {
        return Carbon::createFromFormat('Y-m-d', $value)->translatedFormat(CompanySetting::first()->date_format);
    }

    public function getEndtDateAttribute($value)
    {
        return Carbon::createFromFormat('Y-m-d', $value)->translatedFormat(CompanySetting::first()->date_format);
    }

    public function setStartTimeAttribute($value)
    {
        $leaveStartTime = Carbon::parse($value)->shiftTimezone(CompanySetting::first()->timezone);
        $this->attributes['start_time'] = $leaveStartTime->setTimezone('UTC');
    }

    public function setEndTimeAttribute($value)
    {
        $leaveEndTime = Carbon::parse($value)->shiftTimezone(CompanySetting::first()->timezone);
        $this->attributes['end_time'] = $leaveEndTime->setTimezone('UTC');
    }

    public function setStartDateAttribute($value)
    {
        $this->attributes['start_date'] = Carbon::parse($value)->format('Y-m-d');
    }

    public function setEndDateAttribute($value)
    {
        $this->attributes['end_date'] = Carbon::parse($value)->setTimezone('UTC');
    }

}
