<?php

use App\Module;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RemovePosModuleFromModulesTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $module = Module::select('id')->where('name', 'point_of_sale')->first();

        if ($module) {
            $module->permissions()->each(function ($permission) {
                $permission->roles()->detach($permission->id);
                $permission->delete();
            });
            $module->delete();
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('modules', function (Blueprint $table) {
            //
        });
    }

}
